/* sea-cucumber.m,
 *
 * A floating vulcan turret.
 */

#include <math.h>
#include "common.h"
#include "map.h"
#include "projectiles/evil-vulcan.h"
#include "seborrhea/seborrhea.h"
#include "units/sea-cucumber.h"


static SebFile *cucumber_sebum;


@implementation SeaCucumber
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(EvilVulcan); }
+ derive_loadData(cucumber_sebum, "data/sea-cucumber");
+ derive_shutdown(cucumber_sebum);

- init
{
    [super init];

    speed = 0.0;

    sprite = [cucumber_sebum getSebumByName:"body"];
    turret = [cucumber_sebum getSebumByName:"turret"];
    w = [sprite width];
    h = [sprite height];

    projectile = [EvilVulcan class];
    shot_delay = 10;

    chunk_colours = CHUNK_BLUE;
    return self;
}

- (void) drawTurret:(BITMAP *)dest
{
    /* We want to displace the turret 2 pixels backwards, relative to the
       centre of the tank. */
    if (turret) {
	double x_ = x + (-2.0 * cos(angle)) - offsetX;
	double y_ = y - (-2.0 * sin(angle)) - offsetY;
	[turret drawTo:dest X:x_ Y:y_ Angle:turret_angle];
    }
}
@end
