/* -*- ObjC -*- */
#ifndef __included_boss1_h
#define __included_boss1_h

#include "debri.h"
#include "projectile.h"
#include "unit.h"
#include "weapon.h"

enum {
    BOSS1_SMALL_LEFT_WING = 0, 
    BOSS1_SMALL_RIGHT_WING,
    BOSS1_SATELLITE1,
    BOSS1_SATELLITE2,
    BOSS1_NUM_CHILDREN
};

@protocol Boss1Child
- (void) setParent:(Unit<OwnsChildren> *)unit;
@end

@interface Boss1: Unit <Boss, OwnsChildren>
{
    Unit<Boss1Child> *child[BOSS1_NUM_CHILDREN];
    double fang_y, xv;
    int fire_tics, counter_attack_tics, satellite_tics;
    int bonus_damage;

    Weapon *outer_gun[2];
}
@end

/*------------------------------------------------------------*/

@interface Boss1SmallLeftWing: Unit <Boss1Child>
{
    Unit<OwnsChildren> *parent;
    Sebum<SebImage> *sprite2;	/* Bottom half of wing. */
    Sebum<SebImage> *sprite3;	/* Entire wing picture. */
    int t;			/* time after activation. */

    Weapon *bay1, *bay2, *bay3;
}
@end

#endif
