/* newt.m,
 *
 * A fast, light-ish tank.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "debris/tank-track.h"
#include "debris/turret.h"
#include "map.h"
#include "projectiles/fireball.h"
#include "seborrhea/seborrhea-allegro.h" /* XXX */
#include "seborrhea/seborrhea.h"
#include "units/newt.h"


static SebFile *newt_sebum;
static SebAnimation *move_anim, *fire_anim;

/*------------------------------------------------------------*/

@interface NewtTrack: TankTrack
@end

@interface NewtTurretDebri: TurretDebri
@end

/*------------------------------------------------------------*/

@implementation Newt
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Fireball); }

+ (BOOL) loadData
{
    newt_sebum = [SebFile new];
    if (not [newt_sebum loadSebumDirectory:"data/newt"])
	return NO;

    move_anim = (SebAnimation *)[newt_sebum getSebumByName:"move-anim"];
    fire_anim = (SebAnimation *)[newt_sebum getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(newt_sebum);
    move_anim = nil;
    fire_anim = nil;
}

- init
{
    [super init];

    health = 5;
    speed = 1.0;
    activate_y = -100;

    move_animation.anim  = move_anim;
    move_animation.delay = 3;

    sprite = [move_animation.anim getFrame:-1];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    projectile = [Fireball class];
    shot_delay = 70;

    turret_debri = [NewtTurretDebri class];
    tracks = [NewtTrack class];
    track_separation = 15.0;

    chunk_colours = CHUNK_GREEN;
    return self;
}

- (void) drawTurret:(BITMAP *)dest
{
    /* We want to displace the turret 9 pixels backwards, relative to the
       centre of the tank. */
    if (turret) {
	double x_ = x + (-9.0 * cos(angle)) - offsetX;
	double y_ = y - (-9.0 * sin(angle)) - offsetY;
	[turret drawTo:dest X:x_ Y:y_ Angle:turret_angle];
    }
}
@end

/*------------------------------------------------------------*/

@implementation NewtTrack
- init
{
    [super init];
    health = max_track_life = 100;
    sprite = [newt_sebum getSebumByName:"tracks"];
    return self;
}
@end

@implementation NewtTurretDebri
- init
{
    [super init];
    health = max_health = 60;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
