/* ms-hoover.m,
 *
 * A hovercraft.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "projectiles/maser.h"
#include "seborrhea/seborrhea.h"
#include "units/ms-hoover.h"


static SebFile *hoover_sebum;


@implementation MsHoover
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Maser); }
+ derive_loadData(hoover_sebum, "data/ms-hoover");
+ derive_shutdown(hoover_sebum);

- init
{
    [super init];

    sprite = [hoover_sebum getSebumByName:"body"];
    shadow = nil;
    w = [sprite width];
    h = [sprite height];

    return self;
}
@end
