/* -*- ObjC -*- */
#ifndef __included_mozzie_h
#define __included_mozzie_h

#include "unit.h"
#include "units/hatch.h"
#include "waypoint.h"

#define MOZZIE_STEPS		100

@interface Mozzie: Unit
{
    waypoint_t *the_path;
    int path_progress;
    int path_x_displacement, path_y_displacement;

    int fire_tics, shot_delay;
    Class projectile;

    Unit *target;
}
- (BOOL) generatePath;
- (void) freePathSpline;
@end

@interface MozzieHatch: Hatch
@end

#endif
