/* moan.m,
 *
 * Asymmerical ship with a vulcan cannon and laser.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "projectiles/evil-vulcan.h"
#include "projectiles/pulse-laser.h"
#include "seborrhea/seborrhea.h"
#include "units/moan.h"


static SebFile *moan_sebum;


@implementation Moan
+ (BOOL) loadPrerequisites
{
    return (LOAD_PROJECTILE_DATA_FOR(EvilVulcan) &&
	    LOAD_PROJECTILE_DATA_FOR(PulseLaser));
}

+ derive_loadData(moan_sebum, "data/moan");
+ derive_shutdown(moan_sebum);

- init
{
    [super init];

    health = 5;
    speed = 0.6;

    sprite = [moan_sebum getSebumByName:"body"];
    shadow = [moan_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];
    rotatable_unit = YES;

    gun = [[[[[OffcentrePulseWeapon new]
		 setProjectile:[EvilVulcan class]]
		setShotDelay:3 WaveDelay:40]
	       setShotsPerWave:2]
	      setXDisplacement:15 YDisplacement:-15];
    laser = [[[[OffcentreWeapon new]
		  setProjectile:[PulseLaser class]]
		 setShotDelay:100]
		setXDisplacement:15 YDisplacement:15];

    chunk_colours = CHUNK_GREEN;
    return self;
}

- free
{
    if (laser)
	laser = [laser free];
    return [super free];
}

- (void) fireProjectiles
{
    [gun    fireFromX:x Y:y angle:angle];
    [laser  fireFromX:x Y:y angle:angle];
}
@end
