/* -*- ObjC -*- */
#ifndef __included_miniboss1_h
#define __included_miniboss1_h

#include "animation.h"
#include "unit.h"

enum MINIBOSS1_PHASE {
    MINIBOSS1_SWAY1,
    MINIBOSS1_CHARGE1,			/* Down. */
    MINIBOSS1_SWAY2,
    MINIBOSS1_CHARGE2,			/* Diagonal. */
    MINIBOSS1_RETREAT1,			/* Brake/Turn. */
    MINIBOSS1_RETREAT2,			/* Head back up. */
    MINIBOSS1_RETREAT3,			/* Turn. */
    MINIBOSS1_RETREAT4			/* Reposition. */
};

@interface MiniBoss1: Unit <Boss>
{
    Unit *lgun, *rgun;
    int fire_tics, hunter_tics;
    int sign;				/* CW/CCW. */
    int phase_tics, sway_tics;
    enum MINIBOSS1_PHASE boss_phase;

    double omega;				/* For death. */
    int bonus_damage;

    animation_t animation;
}
@end

#endif
