/* -*- ObjC -*- */
#ifndef __included_miniboss0_h
#define __included_miniboss0_h

#include "animation.h"
#include "debris/turret.h"
#include "unit.h"
#include "weapon.h"

#define MINIBOSS0_GUN_TURRET		0
#define MINIBOSS0_LASER_TURRET		1
#define MINIBOSS0_RAILGUN_TURRET	2
#define MINIBOSS0_NUM_CHILDREN		3

@protocol MiniBoss0Child
- (id) setParent:(Unit<OwnsChildren> *)unit;
- (int) health;
@end

@protocol MiniBoss0Debri
- (void) die;
@end

/*------------------------------------------------------------*/

@interface MiniBoss0: Unit <Boss, OwnsChildren>
{
    double travel_range;
    double last_track_y;
    Unit<MiniBoss0Child> *child[MINIBOSS0_NUM_CHILDREN];
    Debri<MiniBoss0Debri> *debri[MINIBOSS0_NUM_CHILDREN];

    animation_t animation;	/* Moving anim. */
    RingWeapon *ring_gun;	/* Used after the Railgun is destroyed. */
}
@end

/*------------------------------------------------------------*/

@interface MiniBoss0AbstractChild: Unit <MiniBoss0Child>
{
    int child_num;
    Unit<OwnsChildren> *parent;
    double desired_angle, max_rotation_angle;
    int shot_delay, fire_tics;

    animation_t animation;
}
- (void) findDesiredAngle;
@end

@interface MiniBoss0AbstractOverlay: Debri <MiniBoss0Debri>
{
    int child_num;
}
@end

/*------------------------------------------------------------*/

@interface MiniBoss0Tracks: Debri
@end

#endif
