/* lizard.m,
 *
 * A double-barrelled tank.
 */

#include <math.h>
#include "common.h"
#include "debris/tank-track.h"
#include "debris/turret.h"
#include "projectiles/fireball.h"
#include "seborrhea/container-animation.h"
#include "units/lizard.h"


static SebFile *lizard_sebum;
static SebAnimation *move_anim, *fire_left, *fire_right;

/*------------------------------------------------------------*/

@interface LizardTrack: TankTrack
@end

@interface LizardTurretDebri: TurretDebri
@end

/*------------------------------------------------------------*/

@implementation Lizard
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Fireball); }

+ (BOOL) loadData
{
    lizard_sebum = [SebFile new];
    if (not [lizard_sebum loadSebumDirectory:"data/lizard"])
	return NO;

    move_anim  = (SebAnimation *)[lizard_sebum getSebumByName:"move-anim"];
    fire_left  = (SebAnimation *)[lizard_sebum getSebumByName:"fire-l"];
    fire_right = (SebAnimation *)[lizard_sebum getSebumByName:"fire-r"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(lizard_sebum);
    move_anim  = nil;
    fire_left  = nil;
    fire_right = nil;
}

- init
{
    [super init];

    health = 8;
    speed = 0.5;
    activate_y = -100;

    move_animation.anim  = move_anim;
    move_animation.delay = 5;

    sprite = [move_animation.anim getFrame:-1];
    turret = [[SebAnimator new] setAnimation:fire_left];
    w = [sprite width];
    h = [sprite height];

    gun = [[[[DualWeapon new]
		setProjectile:[Fireball class]]
	       setShotDelay:60 WaveDelay:60]
	      setXDisplacement:0 YDisplacement:2];

    turret_debri = [LizardTurretDebri class];
    tracks = [LizardTrack class];
    track_separation = 16.0;

    chunk_colours = CHUNK_GREEN;
    return self;
}

- free
{
    if (gun)
	gun = [gun free];
    return [super free];
}

- (void) fire
{
    if ([gun fireFromX:x Y:y angle:turret_angle]) {
	if ([gun currentShot] == 0)
	    [(SebAnimator *)turret setAnimation:fire_left];
	else
	    [(SebAnimator *)turret setAnimation:fire_right];
    }
}
@end

/*------------------------------------------------------------*/

@implementation LizardTrack
- init
{
    [super init];
    health = max_track_life = 200;
    sprite = [lizard_sebum getSebumByName:"tracks"];
    return self;
}
@end

@implementation LizardTurretDebri
- init
{
    [super init];
    sprite = [fire_left getFrame:-1];
    health = max_health = 60;
    return self;
}
@end
