/* little-death.m,
 *
 * Parabolic path followers that give nuke powerups upon death.
 */

#include <math.h>
#include "common.h"
#include "powerup.h"
#include "seborrhea/seborrhea.h"
#include "units/little-death.h"


static SebFile *little_sebum;


@implementation LittleDeath
+ derive_loadData(little_sebum, "data/little-death");
+ derive_shutdown(little_sebum);

- init
{
    [super init];

    health = 5;
    speed = 5.0;
    the_way = (SebSpline *)[little_sebum getSebumByName:"path"];

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)[little_sebum getSebumByName:"move-anim"]];
    shadow = [little_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height] - 6;

    /* By default, Little Death's will give you nukes. */
    flags |= FLAG_DEATH_SPAWN_NUKE_POWERUP;
    return self;
}
@end
