/* lint.m,
 *
 * A tan-shaped path following puny ship.  Weak, but annoying.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "debris/speed-shadow.h"
#include "player.h"
#include "projectiles/fireball.h"
#include "seborrhea/seborrhea.h"
#include "unit-mapextras.h"
#include "unit-seeking.h"
#include "units/all-units.h"
#include "units/lint.h"


static SebFile *lint_sebum;


@interface LintTrail: RotatedSpeedShadow
@end

/*------------------------------------------------------------*/

@implementation Lint
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Fireball); }

+ (BOOL) loadData
{
    if (lint_sebum)		/* Don't load twice. */
	return YES;

    lint_sebum = [SebFile new];
    return [lint_sebum loadSebumDirectory:"data/lint"];
}

+ derive_shutdown(lint_sebum);

- init
{
    [super init];

    speed = 8.0;
    the_way = (SebSpline *)[lint_sebum getSebumByName:"path2"];

    sprite = [lint_sebum getSebumByName:"lint"];
    shadow = [lint_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];
    rotatable_unit = YES;

    gun = [[[[Weapon new]
		setProjectile:[Fireball class]]
	       setShotDelay:60] setFireTics:30];

    group_num = 0;
    group = NULL;

    chunk_colours = CHUNK_GREEN;    
    return self;
}

- free
{
    if (gun)
	gun = [gun free];
    return [super free];
}

- (void) die
{
    if ([group dropGroupRef]) {
	/* The entire group was destroyed -> bonus score!  Give to all
	   players because it's easier and maybe both contributed. */
	if (player[0]) [player[0] increaseScore:1000];
	if (player[1]) [player[1] increaseScore:1000];
    }
    else {
	/* Don't spawn powerups. */
	flags = 0;
    }

    [super die];
}

- (int) update
{
    if (game_flags & FLAG_PLAYERS_ALIVE)
	[gun fireFromX:x Y:y angle:ANGLE_TO_CLOSEST_ALLY(x, y)];
    [spawn_debris([LintTrail class], x, y, MEDIUM_LAYER) setAngle:angle];
    return [super update];
}

	/* Load/Save.  format: group_num;x;y;a[;flags] */
- (void) importUnitProperties:(char *)str
{
    char str2[1024];

    sscanf(str, "%d;%s", &group_num, str2);
    [super importUnitProperties:str2];

    /* Find the appropriate group to add it to. */
    group = getGroupRef(group_num);
}

- (char *) exportUnitProperties:(char *)str
{
    char str2[1024] = "\0";

    [super exportUnitProperties:str2];
    snprintf(str, sizeof(str2), "%d;%s", group_num, str2);
    return str;
}

	/* For use in map editor only! */
- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    draw_group_num(dest, x, y, group_num);
}

	/* Protocols. */
- derive_setGroup(group_num);
@end

/*------------------------------------------------------------*/

@implementation LintReverse
- init
{
    [super init];
    angle = deg2rad(90.0);
    the_way = (SebSpline *)[lint_sebum getSebumByName:"path3"];
    activate_y = -screen_h;
    return self;
}

- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    draw_fixed_activation_line(dest, x, y, activate_y);
}

	/* Data sharing tweaks. */
+ (BOOL) loadData { return LOAD_UNIT_DATA_FOR(Lint, YES); }
+ (void) shutdown {}
@end

/*------------------------------------------------------------*/

@implementation LintTrail
- init
{
    [super init];
    health = max_health = 10;
    sprite = [lint_sebum getSebumByName:"speedy"];
    return self;
}
@end
