/* kamikaze.m,
 *
 * Ships that try to ram the player to death.  Many different paths.
 */

#include <math.h>
#include "common.h"
#include "debris/smoke.h"
#include "linklist.h"
#include "map.h"
#include "seborrhea/seborrhea.h"
#include "unit-seeking.h"
#include "units/all-units.h"
#include "units/kamikaze.h"


static SebFile *kamikaze_sebum;
static SebAnimation *kamikaze_anim;


@implementation Kamikaze
+ (BOOL) loadData
{
    if (kamikaze_sebum)		/* Don't load twice. */
	return YES;

    kamikaze_sebum = [SebFile new];
    if (not [kamikaze_sebum loadSebumDirectory:"data/kamikaze"])
	return NO;

    /* Yes, I know the shadow should change. */
    kamikaze_anim = (SebAnimation *)[kamikaze_sebum getSebumByName:"move-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(kamikaze_sebum);
    kamikaze_anim = nil;
}

- init
{
    [super init];

    speed = 13.0;
    the_way = (SebSpline *)[kamikaze_sebum getSebumByName:"path"];

    sprite = [[SebAnimator new] setAnimation:kamikaze_anim];
    shadow = [kamikaze_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];
    rotatable_unit = YES;

    chunk_colours = CHUNK_BLUE;
    return self;
}

- (int) update
{
    spawn_debris([Smoke class], x, y, HIGH_LAYER);
    return [super update];
}
@end

/*------------------------------------------------------------*/

@implementation KamikazeCenter
- init
{
    [super init];
    the_way = (SebSpline *)[kamikaze_sebum getSebumByName:"path-centre"];
    return self;
}

	/* Data sharing tweaks. */
+ (BOOL) loadData { return LOAD_UNIT_DATA_FOR(Kamikaze, YES); }
+ (void) shutdown {}
@end

/*------------------------------------------------------------*/

@implementation KamikazeCharger
- init					/* Same as Kamikaze. */
{
    [super init];

    speed = 13.0;

    sprite = [[SebAnimator new] setAnimation:kamikaze_anim];
    shadow = [kamikaze_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];
    rotatable_unit = YES;

    chunk_colours = CHUNK_BLUE;
    return self;
}

- (BOOL) readyToActivate
{
    if ([super readyToActivate]) {
	angle = ANGLE_TO_CLOSEST_ALLY(x, y);
	return YES;
    }
    else
	return NO;
}
 
- (int) update				/* Same as Kamikaze */
{
    spawn_debris([Smoke class], x, y, HIGH_LAYER);
    return [super update];
}

	/* Data sharing tweaks. */
+ (BOOL) loadData { return LOAD_UNIT_DATA_FOR(Kamikaze, YES); }
+ (void) shutdown {}
@end

/*------------------------------------------------------------*/

@implementation KamikazeHook
- init
{
    [super init];
    the_way = (SebSpline *)[kamikaze_sebum getSebumByName:"path-hook"];
    return self;
}

	/* Data sharing tweaks. */
+ (BOOL) loadData { return LOAD_UNIT_DATA_FOR(Kamikaze, YES); }
+ (void) shutdown {}
@end
