/* hunter.m,
 *
 * A turret that launches Hunter-Seekers in pairs.
 */

#include <math.h>
#include "common.h"
#include "debris/turret.h"
#include "seborrhea/container-animation.h"
#include "units/all-units.h"
#include "units/hunter-seeker.h"
#include "units/hunter.h"


static SebFile *hunter_sebum;
static SebAnimation *fire_anim;

/*------------------------------------------------------------*/

@interface HunterBaseDebri: Debri
@end

@interface HunterTurretDebri: TurretDebri
@end

/*------------------------------------------------------------*/

@implementation Hunter
+ (BOOL) loadPrerequisites { return LOAD_UNIT_DATA_FOR(HunterSeeker, YES); }

+ (BOOL) loadData
{
    hunter_sebum = [SebFile new];
    if (not [hunter_sebum loadSebumDirectory:"data/hunter"])
	return NO;

    fire_anim = (SebAnimation *)[hunter_sebum getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(hunter_sebum);
    fire_anim = nil;
}

- init
{
    [super init];

    health = 12;

    sprite = [hunter_sebum getSebumByName:"stand"];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    fire_tics = 50;

    base_debri    = [HunterBaseDebri class];
    turret_debri  = [HunterTurretDebri class];
    chunk_colours = CHUNK_SARDAUKAR;
    return self;
}

- (void) fire
{
    fire_tics--;

    if (fire_tics == 10) {
	double x_ = x + (-5*sin(angle) + 20*sin(angle+M_PI_2));
	double y_ = y + (-5*cos(angle) + 20*cos(angle+M_PI_2));

	[spawn_unit([HunterSeeker class], x_, y_, ACTIVE_AIR_LIST, NO) setAngle:angle];
	[(SebAnimator *)turret setAnimation:fire_anim];
    }
    else if (fire_tics <= 0) {
	double x_ = x + (5*sin(angle) + 20*sin(angle+M_PI_2));
	double y_ = y + (5*cos(angle) + 20*cos(angle+M_PI_2));

	[spawn_unit([HunterSeeker class], x_, y_, ACTIVE_AIR_LIST, NO) setAngle:angle];

	fire_tics = 60;
    }
}
@end

/*------------------------------------------------------------*/

@implementation HunterBaseDebri
- init
{
    [super init];
    sprite = [hunter_sebum getSebumByName:"debri"];
    return self;
}
@end

@implementation HunterTurretDebri
- init
{
    [super init];
    health = max_health = 100;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
