/* hippo.m,
 *
 * A heavily armoured tank with two barrels.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "debris/tank-track.h"
#include "debris/turret.h"
#include "map.h"
#include "projectiles/plasma.h"
#include "rottrans.h"
#include "seborrhea/container-animation.h"
#include "units/all-units.h"
#include "units/hippo.h"


static SebFile *hippo_sebum;
static SebAnimation *move_anim, *fire_anim;

/*------------------------------------------------------------*/

@interface HippoTrack: TankTrack
@end

@interface HippoTurretDebri: TurretDebri
@end

/*------------------------------------------------------------*/

@implementation Hippo
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Plasma); }

+ (BOOL) loadData
{
    hippo_sebum = [SebFile new];
    if (not [hippo_sebum loadSebumDirectory:"data/hippo"])
	return NO;

    move_anim = (SebAnimation *)[hippo_sebum getSebumByName:"move-anim"];
    fire_anim = (SebAnimation *)[hippo_sebum getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(hippo_sebum);
    move_anim = nil;
    fire_anim = nil;
}

- init
{
    [super init];

    health = 15;
    speed = 0.60;
    activate_y = -100;

    move_animation.anim  = move_anim;
    move_animation.delay = 6;

    sprite = [move_animation.anim getFrame:0];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    projectile = nil;
    gun = [[[[DualWeapon new]
		setProjectile:[Plasma class]]
	       setShotDelay:0 WaveDelay:60]
	      setXDisplacement:15 YDisplacement:5];

    turret_debri = [HippoTurretDebri class];
    tracks = [HippoTrack class];
    track_separation = 18.0;

    chunk_colours = CHUNK_COFFEE;
    return self;
}

- free
{
    if (gun)
	gun = [gun free];
    return [super free];
}

- (void) fire
{
    if ([gun fireFromX:x Y:y angle:turret_angle])
	[(SebAnimator *)turret setAnimation:fire_anim];
}
@end

/*------------------------------------------------------------*/

@implementation HippoHatch
+ (BOOL) loadPrerequisites { return LOAD_UNIT_DATA_FOR(Hippo, NO); }

- init
{
    [super init];
    spawnee = [Hippo class];
    return self;
}

- (void) draw:(BITMAP *)dest
{
    [super draw:dest];

    /* Fade a Hippo into existance. */
    if (spawnee && anim.frame > 0) {
	[(<SebImage>)[hippo_sebum getSebumByName:"hatchme"]
		     drawTo:dest X:x-offsetX Y:y-offsetY Alpha:alpha Angle:angle];
    }
}
@end

/*------------------------------------------------------------*/

@implementation HippoTrack
- init
{
    [super init];
    health = max_track_life = 150;
    sprite = [hippo_sebum getSebumByName:"tracks"];
    return self;
}
@end

@implementation HippoTurretDebri
- init
{
    [super init];
    health = max_health = 70;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
