/* grunt.m,
 *
 * Asymmetrical ship equipped with a vulcan on the right wing and
 * dumbfire missiles on the left.
 */

#include <math.h>
#include "common.h"
#include "projectiles/dumbfire.h"
#include "projectiles/evil-vulcan.h"
#include "seborrhea/container-animation.h"
#include "units/grunt.h"


static SebFile *grunt_sebum;
static SebAnimation *move_anim, *fire_anim;


@implementation Grunt
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(EvilVulcan); }

+ (BOOL) loadData
{
    grunt_sebum = [SebFile new];
    if (not [grunt_sebum loadSebumDirectory:"data/grunt"])
	return NO;

    move_anim = (SebAnimation *)[grunt_sebum getSebumByName:"move-anim"];
    fire_anim = (SebAnimation *)[grunt_sebum getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(grunt_sebum);
    move_anim = nil;
    fire_anim = nil;
}

- init
{
    [super init];

    health = 3;
    speed = 0.6;

    sprite = [[SebAnimator new] setAnimation:move_anim];
    shadow = [grunt_sebum getSebumByName:"shadow"];
    w = [sprite width] - 12;
    h = [sprite height];
    rotatable_unit = YES;

    gun = [[[[[OffcentrePulseWeapon new]
		 setProjectile:[EvilVulcan class]]
		setShotDelay:3 WaveDelay:70]
	       setShotsPerWave:3]
	      setXDisplacement:12 YDisplacement:13];

    missile = [[[[OffcentreWeapon new]
		    setProjectile:[DumbfireLeft class]]
		   setShotDelay:100]
		  setXDisplacement:0 YDisplacement:-14];
    
    chunk_colours = CHUNK_GREEN;
    return self;
}

- free
{
    if (missile)
	missile = [missile free];
    return [super free];
}

- (int) update
{
    if ([(SebAnimator *)sprite animationEnded])
	[(SebAnimator *)sprite setAnimation:move_anim];

    return [super update];
}

- (void) fireProjectiles
{
    [missile fireFromX:x Y:y angle:angle+deg2rad(3.0)];

    if ([gun fireFromX:(x+rnd(-1, 1)) Y:y angle:angle] &&
	[(<PulseWeapon>)gun currentShot] == 1)
	[(SebAnimator *)sprite setAnimation:fire_anim];
}
@end
