/* gecko.m,
 *
 * A machine-gun turret tank.  Light armour, but still very nasty.
 */

#include "common.h"
#include "debris/tank-track.h"
#include "debris/turret.h"
#include "projectiles/evil-vulcan.h"
#include "seborrhea/container-animation.h"
#include "units/gecko.h"


static SebFile *gecko_sebum;
static SebAnimation *move_anim, *fire_anim;

/*------------------------------------------------------------*/

@interface GeckoTrack: TankTrack
@end

@interface GeckoTurretDebri: TurretDebri
@end

/*------------------------------------------------------------*/

@implementation Gecko
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(EvilVulcan); }

+ (BOOL) loadData
{
    gecko_sebum = [SebFile new];
    if (not [gecko_sebum loadSebumDirectory:"data/gecko"])
	return NO;

    move_anim = (SebAnimation *)[gecko_sebum getSebumByName:"move-anim"];
    fire_anim = (SebAnimation *)[gecko_sebum getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(gecko_sebum);
    move_anim = nil;
    fire_anim = nil;
}

- init
{
    [super init];

    health = 4;
    speed = 0.8;
    activate_y = -100;

    move_animation.anim  = move_anim;
    move_animation.delay = 4;

    sprite = [move_animation.anim getFrame:-1];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    projectile = [EvilVulcan class];
    shot_delay = 10;
    wave_delay = 60;
    shots_per_wave = 4;

    turret_debri = [GeckoTurretDebri class];
    tracks = [GeckoTrack class];
    track_separation = 16.0;

    chunk_colours = CHUNK_GREEN;
    return self;
}

- (void) fire
{
    if (not projectile || --fire_tics > 0)
        return;

    [spawn_projectile(projectile, x, y, NO) setAngle:turret_angle];

    if (current_shot_number == 0)
	turret = [(SebAnimator *)turret setAnimation:fire_anim];

    if (++current_shot_number >= shots_per_wave) {
	current_shot_number = 0;
	fire_tics = wave_delay;
    }
    else
	fire_tics = shot_delay;
}
@end

/*------------------------------------------------------------*/

@implementation GeckoTrack
- init
{
    [super init];
    health = max_track_life = 150;
    sprite = [gecko_sebum getSebumByName:"tracks"];
    return self;
}
@end

@implementation GeckoTurretDebri
- init
{
    [super init];
    health = max_health = 55;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
