/* firefox.m,
 *
 * Dual-machine-gun ship with light armour.  Very nasty.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "projectiles/evil-vulcan.h"
#include "seborrhea/container-animation.h"
#include "units/firefox.h"


static SebFile *firefox_sebum;
static SebAnimation *fire_anim;


@implementation FireFox
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(EvilVulcan); }

+ (BOOL) loadData
{
    firefox_sebum = [SebFile new];
    if (not [firefox_sebum loadSebumDirectory:"data/firefox"])
	return NO;

    fire_anim = (SebAnimation *)[firefox_sebum getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(firefox_sebum);
    fire_anim = nil;
}

- init
{
    [super init];

    health = 3;
    speed = 2.0;

    sprite = [[SebAnimator new] setAnimation:fire_anim];
    shadow = [firefox_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];
    rotatable_unit = YES;

    gun = [[[[[DualWeapon new]
		 setProjectile:[EvilVulcan class]]
		setShotDelay:-8 WaveDelay:80]
	       setShotsPerWave:3]
	      setXDisplacement:25 YDisplacement:9];

    chunk_colours = CHUNK_RED;
    return self;
}

- (void) fireProjectiles
{
    if ([gun fireFromX:x Y:y angle:angle]) {
	/* Just started firing -> reset the animation. */
	if ([(DualWeapon *)gun currentShot] == 1)
	    sprite = [(SebAnimator *)sprite setAnimation:fire_anim];
    }
}
@end
