/* fireflea.m,
 *
 * Light, semi-circular path following ships.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "projectiles/evil-vulcan.h"
#include "seborrhea/seborrhea.h"
#include "units/fireflea.h"


static SebFile *fireflea_sebum;


@implementation FireFlea
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(EvilVulcan); }
+ derive_loadData(fireflea_sebum, "data/fireflea");
+ derive_shutdown(fireflea_sebum);

- init
{
    [super init];

    speed = 2.0;
    the_way = (SebSpline *)[fireflea_sebum getSebumByName:"semicircle"];
    activate_y = -80;

    sprite = [fireflea_sebum getSebumByName:"fireflea"];
    shadow = [fireflea_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];
    rotatable_unit = YES;

    /* Firing. */
    gun = [[[[PulseWeapon new]
		setProjectile:[EvilVulcan class]]
	       setShotDelay:8 WaveDelay:40]
	      setShotsPerWave:2];

    flags |= FLAG_FIRING_ENABLED;
    chunk_colours = CHUNK_RED;
    return self;
}

- free
{
    if (gun)
	gun = [gun free];
    return [super free];
}

- (id) setX:(double)x_ Y:(double)y_
{
    [super setX:x_ Y:y_];

    /* We want the path to originate 30 pixels to the left/right of the screen. */
    path_x_displacement = -30;

    /* This is really just to look good in the map editor. */
    if (x < screen_w / 2)
	angle = 0;
    else
	angle = M_PI;

    return self;
}

- (void) fire { [gun fireFromX:x Y:y angle:angle]; }
@end
