/* deceiver.m,
 *
 * Annoying little ships that (usually) sneak up from behind the
 * player and threaten to touch them.  No guns.  Good for nudging the
 * player towards a certain part of the screen.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "seborrhea/seborrhea.h"
#include "unit-mapextras.h"
#include "units/deceiver.h"


static SebFile *deceiver_sebum;


@implementation Deceiver
+ derive_loadData(deceiver_sebum, "data/deceiver");
+ derive_shutdown(deceiver_sebum);

- init
{
    [super init];

    health = 3;
    speed = 2.5;
    angle = -M_PI_2;
    activate_y = -480;

    sprite = [deceiver_sebum getSebumByName:"deceiver"];
    shadow = [deceiver_sebum getSebumByName:"shadow"];

    /* Smaller than sprite size so can squeeze through more easily. */
    w = [sprite width]-2;
    h = [sprite height]-2;
    rotatable_unit = YES;

    chunk_colours = CHUNK_GREEN;
    return self;
}

	/* For use in map editor only! */
- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    draw_activation_line(dest, x, y, activate_y);
}

	/* Protocol stuff. */
- derive_setActivationLine;
- derive_importUnitPropertiesWithVariableActivationLine;
- derive_exportUnitPropertiesWithVariableActivationLine;
@end
