/* cruiser.m,
 *
 * Lightly armoured missile ships.
 */

#include "common.h"
#include "projectiles/rocket.h"
#include "seborrhea/container-animation.h"
#include "units/cruiser.h"


static SebFile *cruiser_sebum;


@implementation Cruiser
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Rocket); }
+ derive_loadData(cruiser_sebum, "data/cruiser");
+ derive_shutdown(cruiser_sebum);

- init
{
    [super init];

    health = 4;
    speed = 1.05;

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)[cruiser_sebum getSebumByName:"move-anim"]];
    shadow = [cruiser_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height] - 10;

    gun = [[[[[DualWeapon new]
		 setProjectile:[Rocket class]]
		setShotDelay:-30 WaveDelay:75]
	       setShotsPerWave:2]
	      setXDisplacement:5 YDisplacement:12];

    chunk_colours = CHUNK_BLUE;
    return self;
}
@end
