/* conquerer.m,
 */

#include <allegro.h>
#include "common.h"
#include "projectiles/maser.h"
#include "seborrhea/seborrhea.h"
#include "units/conquerer.h"


static SebFile *conquerer_sebum;


@implementation Conquerer
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Maser); }
+ derive_loadData(conquerer_sebum, "data/conquerer");
+ derive_shutdown(conquerer_sebum);

- init
{
    [super init];

    health = 6;
    speed = 1.05;

    sprite = [conquerer_sebum getSebumByName:"conquerer"];
    shadow = [conquerer_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];

    gun = [[[Weapon new]
	       setProjectile:[Maser class]]
	      setShotDelay:60];

    chunk_colours = CHUNK_GREEN;
    return self;
}
@end
