/* challenger.m,
 */

#include "common.h"
#include "projectiles/railgun.h"
#include "seborrhea/container-animation.h"
#include "units/challenger.h"


static SebFile *challenger_sebum;
static SebAnimation *move_anim, *fire_anim;


@implementation Challenger
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Railgun); }

+ (BOOL) loadData
{
    challenger_sebum = [SebFile new];
    if (not [challenger_sebum loadSebumDirectory:"data/challenger"])
	return NO;

    move_anim = (SebAnimation *)[challenger_sebum getSebumByName:"move-anim"];
    fire_anim = (SebAnimation *)[challenger_sebum getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(challenger_sebum);
    move_anim = nil;
    fire_anim = nil;
}

- init
{
    [super init];

    health = 8;
    speed = 1.1;

    sprite = [[SebAnimator new] setAnimation:move_anim];
    shadow = [challenger_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height] - 14;

    gun = [[[[Weapon new]
		setProjectile:[Railgun class]]
	       setShotDelay:50]
	      setFireTics:50];

    chunk_colours = CHUNK_BLUE;
    return self;
}

- (void) fireProjectiles
{
    if ([gun fireFromX:x Y:y+18 angle:angle]) {
	/* Restore the moving animation. */
	[(SebAnimator *)sprite setAnimation:move_anim];
    }
    else if ((unsigned)[gun fireTics] == 4*[fire_anim numFrames]) {
	/* Start charging up/warning the player. */
	[(SebAnimator *)sprite setAnimation:fire_anim];
    }
}
@end
