/* centipede.m,
 *
 * Long train-like ships that flies at high speed and try to ram the
 * players.  Moderately armoured head, but weak body segments.
 */

#include <allegro.h>
#include "common.h"
#include "map.h"
#include "seborrhea/seborrhea.h"
#include "units/centipede.h"


#define CENTIPEDE_SPEED			8.0
#define CENTIPEDE_NUM_BODY_SEGMENTS	5


static SebFile *centipede_sebum;


@interface CentipedeSegment: Unit
@end

/*--------------------------------------------------------------*/

@implementation Centipede
+ derive_loadData(centipede_sebum, "data/centipede");
+ derive_shutdown(centipede_sebum);

- init
{
    [super init];

    health = 8;
    speed = CENTIPEDE_SPEED;

    sprite = [centipede_sebum getSebumByName:"head"];
    shadow = [centipede_sebum getSebumByName:"shadow-head"];
    w = [sprite width] - 10;
    h = [sprite height];

    chunk_colours = CHUNK_COFFEE;
    return self;
}

- (BOOL) readyToActivate
{
    if ([super readyToActivate]) {	/* Spawn the segments. */
	int i, y_;
	for (i = 0, y_ = y-18; i < CENTIPEDE_NUM_BODY_SEGMENTS; i++, y_ -= 12)
	    spawn_unit([CentipedeSegment class], x, y_, ACTIVE_AIR_LIST, YES);

	return YES;
    }
    else
	return NO;

}

- (void) drawMapEditorExtras:(BITMAP *)dest
{
    /* Draw the segments of the unit. */
    Sebum<SebImage> *segment;
    int i, y_, w_, h_;

    segment = [centipede_sebum getSebumByName:"segment"];
    w_ = [segment width]/2;
    h_ = [segment height]/2;
    for (i = 0, y_ = y-18; i < CENTIPEDE_NUM_BODY_SEGMENTS; i++, y_-=12)
	[segment drawTo:dest X:x-offsetX-w_ Y:y_-offsetY-h_];

    [super drawMapEditorExtras:dest];
}
@end

/*--------------------------------------------------------------*/

@implementation CentipedeSegment
- init
{
    [super init];

    speed = CENTIPEDE_SPEED;

    sprite = [centipede_sebum getSebumByName:"segment"];
    shadow = [centipede_sebum getSebumByName:"shadow-segment"];
    w = [sprite width];
    h = [sprite height];

    flags |= FLAG_MOVING_ENABLED;
    chunk_colours = CHUNK_COFFEE;
    return self;
}
@end
