/* bug.m,
 *
 * Weak and dispendable enemy ships that make lots of explosions.
 */

#include "common.h"
#include "projectiles/fireball.h"
#include "seborrhea/container-animation.h"
#include "units/bug.h"


static SebFile *bug_sebum;


@implementation Bug
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Fireball); }
+ derive_loadData(bug_sebum, "data/bug");
+ derive_shutdown(bug_sebum);

- init
{
    [super init];

    speed = 1.1;

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)[bug_sebum getSebumByName:"move-anim"]];
    shadow = [bug_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height] - 12;

    gun = [[[[PulseWeapon new]
		setProjectile:[Fireball class]]
	       setShotDelay:30 WaveDelay:80]
	      setShotsPerWave:2];

    chunk_colours = CHUNK_BLUE;
    return self;
}
@end
