/* -*- ObjC -*- */
#ifndef __included_boss0_h
#define __included_boss0_h

#include "animation.h"
#include "seborrhea/seborrhea-spline.h"
#include "unit.h"

#define BOSS0_LEFT_WING		0
#define BOSS0_RIGHT_WING	1
#define BOSS0_LEFT_TUSK		2
#define BOSS0_RIGHT_TUSK	3
#define BOSS0_NUM_CHILDREN	4
#define BOSS0_BODY		BOSS0_NUM_CHILDREN
#define BOSS0_NUM_PARTS		(BOSS0_NUM_CHILDREN+1)

/*------------------------------------------------------------*/

@class Boss0Part;

@interface Boss0: Unit <Boss, OwnsChildren>
{
    int t;
    int fireball_tics, fireball_delay;
    int missile_tics, missile_delay, missile_barrel;
    int laser_tics, laser_delay;
    int bonus_damage;

    /* These can't die, so I'm lumping it with the main boss. */
    double turret_angle[2];

    Boss0Part *child[BOSS0_NUM_CHILDREN];

    SebSpline *the_way;
    int path;
}
@end

/*------------------------------------------------------------*/

@interface Boss0Part: Unit
{
    Unit<OwnsChildren> *parent;
    int part_num;
}
- (int) health;
- (id) setParent:(Unit<OwnsChildren> *)unit;
@end

#endif
