/* battler.m,
 */

#include "common.h"
#include "projectiles/maser.h"
#include "seborrhea/seborrhea.h"
#include "units/battler.h"


static SebFile *battler_sebum;


@implementation Battler
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Maser); }
+ derive_loadData(battler_sebum, "data/battler");
+ derive_shutdown(battler_sebum);

- init
{
    [super init];

    health = 4;
    speed = 1.07;

    sprite = [battler_sebum getSebumByName:"battler"];
    shadow = [battler_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];

    gun = [[[Weapon new]
	       setProjectile:[Maser class]]
	      setShotDelay:60];

    chunk_colours = CHUNK_GREEN;
    return self;
}
@end
