/* battle-cruiser.m,
 */

#include "common.h"
#include "projectiles/maser.h"
#include "seborrhea/container-animation.h"
#include "units/battle-cruiser.h"


static SebFile *cruiser_sebum;
static SebAnimation *move_anim, *fire_anim;


@implementation BattleCruiser
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Maser); }

+ (BOOL) loadData
{
    cruiser_sebum = [SebFile new];
    if (not [cruiser_sebum loadSebumDirectory:"data/battle-cruiser"])
	return NO;

    move_anim = (SebAnimation *)[cruiser_sebum getSebumByName:"move-anim"];
    fire_anim = (SebAnimation *)[cruiser_sebum getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(cruiser_sebum);
    move_anim = nil;
    fire_anim = nil;
}

- init
{
    [super init];

    health = 8;
    speed = 1.03;

    sprite = [[SebAnimator new] setAnimation:move_anim];
    shadow = [cruiser_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];

    gun = [[[[[DualWeapon new]
		 setProjectile:[Maser class]]
		setShotDelay:-20 WaveDelay:100]
	       setShotsPerWave:2]
	      setXDisplacement:0 YDisplacement:15];

    chunk_colours = CHUNK_GREEN;
    return self;
}

- (void) fireProjectiles
{
    if ([gun fireFromX:x Y:y])
	[(SebAnimator *)sprite setAnimation:fire_anim];
    else if ([(SebAnimator *)sprite animationEnded]) 
	[(SebAnimator *)sprite setAnimation:move_anim];
}
@end
