/* basturk.m,
 *
 * Bastrk indeed.
 */

#include "common.h"
#include "projectiles/shockwave.h"
#include "seborrhea/seborrhea.h"
#include "units/basturk.h"


static SebFile *basturk_sebum;


@implementation Basturk
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Shockwave); }
+ derive_loadData(basturk_sebum, "data/basturk");
+ derive_shutdown(basturk_sebum);

- init
{
    [super init];

    health = 8;

    sprite = [basturk_sebum getSebumByName:"turret"]; /* XXX */
    turret = [basturk_sebum getSebumByName:"turret"];
    w = [sprite width];
    h = [sprite height];

    gun = [[[[DualWeapon new]
		setProjectile:[Shockwave class]]
	       setShotDelay:20 WaveDelay:60]
	      setXDisplacement:13 YDisplacement:8];

    chunk_colours = CHUNK_RED;
    return self;
}
@end
