/* basic-flyer.m
 *
 * 'Basic-flyer' includes a very basic firing routine.  It is designed to be
 * used as a base class.
 */

#include "common.h"
#include "projectile.h"
#include "seborrhea/seborrhea.h"
#include "units/basic-flyer.h"


@implementation BasicFlyer
        /* Initialization. */
- init
{
    [super init];
    flags |= FLAG_FIRING_ENABLED;
    return self;
}

- free
{
    if (gun)
	gun = [gun free];
    return [super free];
}

	/* Update. */
- (void) fireProjectiles
{
    /* This is the function to replace if you want to shoot 2
       projectiles or something like that. */
    [gun fireFromX:x Y:y];
}

- (void) fire
{
    if (gun)
	[self fireProjectiles];
    else
	flags &=~FLAG_FIRING_ENABLED;
}
@end
