/* baby-boy.m,
 *
 * An annoying little chaser unit.  Very strong before it activates,
 * but weak after it opens up.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "rotate.h"
#include "seborrhea/container-animation.h"
#include "unit-mapextras.h"
#include "unit-seeking.h"
#include "units/baby-boy.h"


static SebFile *baby_sebum;
static SebAnimation *open_anim, *move_anim;


@implementation BabyBoy
+ (BOOL) loadData
{
    baby_sebum = [SebFile new];
    if (not [baby_sebum loadSebumDirectory:"data/baby-boy"])
	return NO;

    open_anim = (SebAnimation *)[baby_sebum getSebumByName:"open-anim"];
    move_anim = (SebAnimation *)[baby_sebum getSebumByName:"move-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(baby_sebum);
    open_anim = nil;
    move_anim = nil;
}

- init
{
    [super init];

    health = 30;		/* But /=5 when opened up */
    speed = 0.0;
    activate_y = -100;
    open_tics = 6*8;

    sprite = [open_anim getFrame:0];
    shadow = [baby_sebum getSebumByName:"shadowc"];
    w = [sprite width];
    h = [sprite height] - 6;
    rotatable_unit = YES;

    chunk_colours = CHUNK_RED;
    return self;
}

- (void) enableMovement
{
    if (not (game_flags & FLAG_PLAYERS_ALIVE))
	return;
    else {
	[super enableMovement];

	if (flags & FLAG_MOVING_ENABLED)
	    sprite = [[SebAnimator new] setAnimation:open_anim];
    }
}

- (void) move
{
    if (open_tics > 0) {
	open_tics--;

	if (open_tics <= 0) {
	    health = MAX(1, health/5);
	    speed = 1.7;
	    h += 6;			/* 6px extra to hit. */
	    sprite = [(SebAnimator *)sprite setAnimation:move_anim];
	    shadow = [baby_sebum getSebumByName:"shadowo"];
	}
    }

    if (!target || !unit_exists(target, ALLY_LIST))
	target = FIND_CLOSEST_ALLY(x, y);

    if (target && speed > 0.0) {
	double theta = angle_towards_unit(x, y, target);
	limited_rotate(&angle, theta, deg2rad(1.8));
	simplify_angle(&angle);
    }

    [super move];
}

- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    draw_activation_line(dest, x, y, activate_y);
}

	/* Protocol stuff. */
- derive_setActivationLine;
- derive_importUnitPropertiesWithVariableActivationLine;
- derive_exportUnitPropertiesWithVariableActivationLine;
@end
