/* armadillo.m,
 *
 * A tank that spray five(!) fireballs at once.  Moderate armour.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "debris/tank-track.h"
#include "debris/turret.h"
#include "map.h"
#include "projectiles/fireball.h"
#include "rottrans.h"
#include "seborrhea/container-animation.h"
#include "units/all-units.h"
#include "units/armadillo.h"


static SebFile *dillo_sebum;
static SebAnimation *move_anim, *fire_anim;

/*------------------------------------------------------------*/

@interface ArmadilloTrack: TankTrack
@end

@interface ArmadilloTurretDebri: TurretDebri
@end

/*------------------------------------------------------------*/

@implementation Armadillo
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Fireball); }

+ (BOOL) loadData
{
    dillo_sebum = [SebFile new];
    if (not [dillo_sebum loadSebumDirectory:"data/armadillo"])
	return NO;

    move_anim = (SebAnimation *)[dillo_sebum getSebumByName:"move-anim"];
    fire_anim = (SebAnimation *)[dillo_sebum getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(dillo_sebum);
    move_anim = nil;
    fire_anim = nil;
}

- init
{
    [super init];

    health = 8;
    speed = 0.7;
    activate_y = -100;

    move_animation.anim  = move_anim;
    move_animation.delay = 4;

    sprite = [move_anim getFrame:0];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    projectile = [Fireball class];
    shot_delay = 60;

    turret_debri = [ArmadilloTurretDebri class];
    tracks = [ArmadilloTrack class];
    track_separation = 16.0;

    chunk_colours = CHUNK_COFFEE;
    return self;
}

- (void) drawTurret:(BITMAP *)dest
{
    /* We want to displace the turret 5 pixels backwards, relative to
       the centre of the tank. */
    if (turret) {
	double x_ = x + (-5.0 * cos(angle)) - offsetX;
	double y_ = y - (-5.0 * sin(angle)) - offsetY;
	[turret drawTo:dest X:x_ Y:y_ Angle:turret_angle];
    }
}

- (void) fire
{
#define FIRE_PROJECTILE(x,y)		spawn_projectile(projectile, x, y, NO)

    fire_tics--;
    if (fire_tics <= 0) {
	[FIRE_PROJECTILE(x,y) setAngle:turret_angle - deg2rad(30.0)];
	[FIRE_PROJECTILE(x,y) setAngle:turret_angle - deg2rad(15.0)];
	[FIRE_PROJECTILE(x,y) setAngle:turret_angle];
	[FIRE_PROJECTILE(x,y) setAngle:turret_angle + deg2rad(15.0)];
	[FIRE_PROJECTILE(x,y) setAngle:turret_angle + deg2rad(30.0)];
	fire_tics = shot_delay;

	[(SebAnimator *)turret setAnimation:fire_anim];
    }

#undef FIRE_PROJECTILE
}
@end

/*------------------------------------------------------------*/

@implementation ArmadilloHatch
+ (BOOL) loadPrerequisites { return LOAD_UNIT_DATA_FOR(Armadillo, NO); }

- init
{
    [super init];
    spawnee = [Armadillo class];
    return self;
}

- (void) draw:(BITMAP *)dest
{
    [super draw:dest];

    /* Fade an Armadillo into existance. */
    if (spawnee && anim.frame > 0) {
	[(<SebImage>)[dillo_sebum getSebumByName:"hatchme"]
		     drawTo:dest X:x-offsetX Y:y-offsetY Alpha:alpha Angle:angle];
    }
}
@end

/*------------------------------------------------------------*/

@implementation ArmadilloTrack
- init
{
    [super init];
    health = max_track_life = 100;
    sprite = [dillo_sebum getSebumByName:"tracks"];
    return self;
}
@end

@implementation ArmadilloTurretDebri
- init
{
    [super init];
    health = max_health = 65;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
