/* anvil.m,
 *
 * Strong Big-Bertha-inspired turret.
 */

#include "common.h"
#include "debris/turret.h"
#include "projectiles/plasma.h"
#include "seborrhea/container-animation.h"
#include "sound.h"
#include "units/anvil.h"


static SebFile *anvil_sebum;
static SebAnimation *fire_anim;

/*------------------------------------------------------------*/

@interface AnvilBaseDebri: Debri
@end

@interface AnvilTurretDebri: TurretDebri
@end

/*------------------------------------------------------------*/

@implementation Anvil
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Plasma); }

+ (BOOL) loadData
{
    anvil_sebum = [SebFile new];
    if (not [anvil_sebum loadSebumDirectory:"data/anvil"])
	return NO;

    fire_anim = (SebAnimation *)[anvil_sebum getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(anvil_sebum);
    fire_anim = nil;
}

- init
{
    [super init];

    health = 14;

    sprite = [anvil_sebum getSebumByName:"stand"];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    gun = [[[Weapon new]
	       setProjectile:[Plasma class]]
	      setShotDelay:40];

    base_debri    = [AnvilBaseDebri class];
    turret_debri  = [AnvilTurretDebri class];
    chunk_colours = CHUNK_RED;
    return self;
}

- (void) fire
{
    if ([gun fireTics] == 1) {
	play_panned_sample((Sebum<SebSample> *)[anvil_sebum getSebumByName:"fire-snd"], x);
	[(SebAnimator *)turret setAnimation:fire_anim];
    }
    [super fire];
}
@end

/*------------------------------------------------------------*/

@implementation AnvilBaseDebri
- init
{
    [super init];
    sprite = [anvil_sebum getSebumByName:"debri"];
    return self;
}
@end

@implementation AnvilTurretDebri
- init
{
    [super init];
    health = max_health = 100;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
