/* -*- ObjC -*- */
#ifndef __included_unit_h
#define __included_unit_h

#include "debris/chunk.inc"
#include "thing.h"
#include "unit-protocol.inc"
#include "collision.inc"

#define SHADOW_DISPLACEMENT	25	/* Other units might want to know. */

enum UNIT_FLAGS {
    FLAG_INVINCIBLE	= 0x01,
    FLAG_FIRING_ENABLED	= 0x02,
    FLAG_MOVING_ENABLED	= 0x04,
    FLAG_DYING		= 0x10,
    FLAG_DEAD		= 0x20,

    /* Any flags beyond this point will be saved! */
    FLAG_DEATH_SPAWN_PRIMARY_POWERUP	= 0x0100,
    FLAG_DEATH_SPAWN_SECONDARY_POWERUP	= 0x0200,
    FLAG_DEATH_SPAWN_TERTIARY_POWERUP	= 0x0400,
    FLAG_DEATH_SPAWN_HEALTH_POWERUP	= 0x0800,
    FLAG_DEATH_SPAWN_NUKE_POWERUP	= 0x1000,
    FLAG_ONLY_SPAWN_IN_TWO_PLAYER	= 0x2000
};

@class Projectile;
struct BITMAP;

@interface Unit: Thing <DetectsCollision>
{
    /* Location & movement */
    int activate_y;		/* Larger means activate earlier. */
    double angle, speed;

    /* Appearance */
    Sebum<SebImage> *shadow;
    BOOL rotatable_unit;
    int flash_tics;

    /* Miscellaneous */
    unsigned int flags;
    unsigned int chunk_colours;
}
        /* Initialization. */
+ (BOOL) loadPrerequisites;
- (id) setAngle:(double)theta;
- (id) setX:(double)x_ Y:(double)y_;
- (void) delete;
- (void) spawnDyingExplosions;
- (void) die;

	/* Drawing. */
- (void) drawShadow:(BITMAP *)dest;

	/* Update. */
- (BOOL) readyToActivate;
- (void) enableMovement;
- (void) move;
- (void) fire;

	/* Collisions */
- (int) flags;
- (int) collisionLists;
- (BOOL) collidesWithRotatedUnit:(Thing<DetectsCollision> *)object;
- (void) getX:(double *)x_ Y:(double *)y_;
- (void) getW:(int *)w_ H:(int *)h_;
- (int) receiveDamage:(int)damage type:(enum DAMAGE_TYPE)type;
- (int) receiveDamage:(int)damage type:(enum DAMAGE_TYPE)type from:(int)unit_id;

	/* Load/Save. */
- (void) importUnitProperties:(char *)str;
- (char *) exportUnitProperties:(char *)str;

	/* For use in map editor only! */
- (void) drawTo:(BITMAP *)dest at:(int)x_ :(int)y_;
- (void) drawMapEditorExtras:(BITMAP *)dest;
- (BOOL) reditSetX:(double)x_ Y:(double)y_;
- (void) toggleFlag:(int)f;
- (double) angle;
@end

/*------------------------------------------------------------*/

extern Unit<Boss> *boss;

void draw_units(BITMAP *dest, enum UNIT_LIST list);
void draw_unit_shadows(BITMAP *dest);

void update_units(void);

Unit *spawn_unit(Class class, double x, double y,
		 enum UNIT_LIST list, BOOL at_start);
void destroy_unit(Unit *unit);

void unit_reset(void);
void unit_init(void);
void unit_shutdown(void);

#endif
