/* -*- ObjC -*- */
#ifndef __included_unit_protocol_inc
#define __included_unit_protocol_inc

@class Unit;

/* See unit-group.h for 'Groupable' protocol. */

/*------------------------------------------------------------*/
/* Useful things. */

#define derive_loadData(sebum,dir)					\
	(BOOL) loadData							\
	{ sebum = [SebFile new]; return [sebum loadSebumDirectory:dir]; }

#define derive_shutdown(sebum)						\
	(void) shutdown							\
	{ FREE_SEBFILE(sebum); }

#define derive_fixedAngle						\
	(id) setAngle:(double)_						\
	{ (void)_; return self; }

#define derive_alwaysInfluenceGameplay					\
	(BOOL) mayStillInfluenceGameplay				\
	{ return YES; }

#define derive_setXYAlwaysCentred					\
	(id) setX:(double)_ Y:(double)y_				\
	{ (void)_; return [super setX:screen_w/2 Y:y_]; }

/*------------------------------------------------------------*/

@protocol Boss
- (void) drawHealthMeter:(BITMAP *)dest;
@end

#define derive_airBossCollisionLists					\
	(int) collisionLists						\
	{ return ALLY_LIST|COLLIDES_WITH_PROJECTILES; }

/*------------------------------------------------------------*/

@protocol OwnsChildren
- (void) disownChild:(Unit *)u;
//- (void) destroyChildren;
@end

/*------------------------------------------------------------*/

@protocol VariableActivationLine
- (id) setActivationLine:(int)y :(BOOL)absolute;
@end

#define derive_setActivationLine					\
	(id) setActivationLine:(int)y_ :(BOOL)absolute			\
	{ if (absolute) activate_y = y_;				\
	  else activate_y += y_;					\
	  activate_y = MID(-screen_h, activate_y, screen_h);		\
	  return self; }

/* Format: activate_y;x;y;a[;flags] */
#define derive_importUnitPropertiesWithVariableActivationLine		\
	(void) importUnitProperties:(char *)str				\
	{ char str2[1024]; int a;					\
	  sscanf(str, "%d;%s", &a, str2);				\
	  [super importUnitProperties:str2];				\
	  activate_y = a; }

#define derive_exportUnitPropertiesWithVariableActivationLine		\
	(char *) exportUnitProperties:(char *)str			\
	{ char str2[1024] = "\0";					\
	  [super exportUnitProperties:str2];				\
	  snprintf(str, sizeof(str2), "%d;%s", activate_y, str2);	\
	  return str; }


/*------------------------------------------------------------*/

@protocol VariableTravelRange
- (id) setTravelRange:(int)r;
@end

#define derive_setTravelRange(travel_range)				\
	(id) setTravelRange:(int)r					\
	{ travel_range = MAX(0, r); return self; }

#endif
