/* thing.m,
 *
 * Everything is a 'Thing'.  Units, projectiles, powerups, etc.
 */

#include <allegro.h>
#include "common.h"
#include "debug.inc"
#include "map.h"
#include "seborrhea/seborrhea-allegro.h" /* XXX */
#include "seborrhea/seborrhea.h"
#include "thing.h"


@implementation Thing
    /* Initialization. */
+ (BOOL) loadData { return YES; }
+ (void) shutdown {}

- init
{
    [super init];
    health = 1;
    return self;
}

- free
{
    if ([sprite conformsTo:@protocol(UniqueSebum)])
	sprite = [sprite free];
    return [super free];
}

- (id) setX:(double)x_ Y:(double)y_
{
    x = x_;
    y = y_;
    return self;
}

    /* Update. */
- (BOOL) mayStillInfluenceGameplay
{
    /* Determines whether this object will angle back onto the screen
       and influence gameplay.  If not, we can remove it.  Things
       which do not move at a fixed angle may want to change this. */
    int x_ = x - offsetX;
    int y_ = y - offsetY;
    int sprite_w_2 = [sprite width]/2;
    int sprite_h_2 = [sprite height]/2;

    if ((x_ + sprite_w_2 < 0) || (x_ - sprite_w_2 > screen_w) ||
	(y_ + sprite_h_2 < 0) || (y_ - sprite_h_2 > screen_h))
	return NO;
    return YES;
}

- (int) update
{
    if (health <= 0)
	return THING_DEAD;

    if (not sprite)
	return THING_DEAD;

    if ([self mayStillInfluenceGameplay])
	return THING_NORMAL;
    else
	return THING_DEAD;
}

    /* Drawing. */
- (void) draw:(BITMAP *)dest
{
    if (sprite) {
	int sprite_w_2 = [sprite width]/2;
	int sprite_h_2 = [sprite height]/2;

	[sprite drawTo:dest X:x-sprite_w_2-offsetX Y:y-sprite_h_2-offsetY];
    }
}

- (void) drawBoundingBox:(BITMAP *)dest
{
#ifdef DEBUG_BOUNDING_BOX
    rect_wh(dest, x-w/2-offsetX, y-h/2-offsetY, w, h, BOUNDING_BOX_COLOUR);
#else
    (void)dest;
#endif
}
@end
