/* -*- ObjC -*- */
#ifndef __included_thing_h
#define __included_thing_h

#include <allegro.h>		/* XXX */
#include <objc/Object.h>
#include "seborrhea/seborrhea.h"

/* Thing:update return values. */
enum {
    THING_NORMAL = 0,
    THING_DEAD = 1
};

@interface Thing: Object
{
    int health;
    double x, y;
    unsigned int w, h;		/* Collision width/height. */

    Sebum<SebImage> *sprite;
}
+ (BOOL) loadData;
+ (void) shutdown;
- (id) setX:(double)x_ Y:(double)y_;
- (BOOL) mayStillInfluenceGameplay;
- (int) update;
- (void) draw:(BITMAP *)dest;
- (void) drawBoundingBox:(BITMAP *)dest;
@end

@protocol DetectsCollision
- (void) getX:(double *)x_ Y:(double *)y_ W:(int *)w_ H:(int *)h_;
- (BOOL) collidesWith:(Thing<DetectsCollision> *)object;
@end

#endif
