/* star-field.m,
 */

#include <allegro.h>
#include "common.h"
#include "map.h"
#include "star-field.h"


#define foreach_star(i)		for (i = 0; i < MAX_STARS; i++)


@implementation StarField
- (id) init
{
    int i, col;

    [super init];

    /* Generate some stars at start of level. */
    foreach_star (i) {
	sx[i] = rnd(0, screen_w);
	sy[i] = rnd(0, screen_h);
	col   = rnd(0x80, 0xa0);
	sc[i] = makecol(col, col, col);
    }

    return self;
}

- (void) update
{
    int i, col;

    /* Only move stars for every 2 pixels the map scroll (the same
       speed as the parallax layer). */
    if (ABS(last_offset_y - offsetY) >=	2.0)
	last_offset_y = offsetY; else return;

    foreach_star (i) {
	sy[i]++;

	/* This star is off the screen, make a new one. */
	if (sy[i] > screen_h) {
	    sx[i] = rnd(0, screen_w);
	    sy[i] = 0;
	    col   = rnd(0x80, 0xa0);
	    sc[i] = makecol(col, col, col);
	}
    }
}

- (void) draw:(BITMAP *)dest
{
    int i;

    foreach_star (i)
	putpixel(dest, sx[i], sy[i], sc[i]);
}
@end
