/* -*- ObjC -*- */
#ifndef __included_token_h
#define __included_token_h

#include <objc/Object.h>

enum TOKEN_TYPE {
    TOKEN_UNINITIALISED = 0,
    TOKEN_SYMBOL,
    TOKEN_STRING,
    TOKEN_FIXNUM,
    TOKEN__MAXTYPE
};

@interface Token: Object
{
    enum TOKEN_TYPE type;
    union {
	struct {
	    char *str;
	    unsigned int len;
	} string;
	struct {
	    int num;
	} fixnum;
    } data;
}
- initAsType: (enum TOKEN_TYPE)type_;

- (void) appendChar:(char)c;		/* symbols/strings ONLY */
- (void) setFixnum:(int)n;		/* fixnums ONLY */

- (enum TOKEN_TYPE) type;
- (BOOL) isType:(enum TOKEN_TYPE)type_;
- (const char *) getSymbol;
- (const char *) getString;
- (int) getFixnum;
@end

int read_char_skip_comment(void *fp);
int read_char_non_ws(void *fp);
BOOL expect_char(void *fp, char expect);
BOOL is_delimiter(char c);
Token *read_symbol(void *fp);
Token *read_string(void *fp);
Token *read_fixnum(void *fp);
Token *read_token(void *fp);

void set_token_reader_stdio(void);

#ifndef NO_ZZIP
void set_token_reader_zzpk(void);
#endif

#endif
