/* -*- ObjC -*- */
#ifndef _seb_included_seborrhea_spline_h
#define _seb_included_seborrhea_spline_h

#include "seborrhea/seborrhea.h"
#include "waypoint.h"

enum SEB_SPLINE_LOOP_METHOD {
    SEB_SPLINE_LOOP_NONE = 0,
    SEB_SPLINE_LOOP_FORWARD
};

@interface SebSpline: Sebum
{
    waypoint_t *waypoint_array;
    unsigned int spline_length;

    enum SEB_SPLINE_LOOP_METHOD loop;
}
- setLoop:(enum SEB_SPLINE_LOOP_METHOD)method;

- (BOOL) loadFromFile:(const char *)file;
- (BOOL) loadFromMemory:(void *)buffer :(int)buffer_size;

- (int) follow:(unsigned int *)progress :(double *)x :(double *)y :(double)speed
	      :(double)x_displacement :(double)y_displacement;
- (double) angleBetween:(unsigned int)alpha :(unsigned int)beta;
@end

#endif
