/* seborrhea-mp3.m,
 *
 * This is for music lumps.
 */

#include <assert.h>
#include "seborrhea-mp3.h"

static BOOL seborrhea_mp3_load(const char *filename, const char *name_sans_ext, unsigned int index,
			       Sebum<SebContainer> *parent, DirectoryList *dirlist);

/*--------------------------------------------------------------*/

@implementation SebMP3
+ (void) load
{
    seborrhea_register_filetype_handler("mp3", seborrhea_mp3_load);
}

- free
{
    if (entire_pathname) {
	free(entire_pathname);
	entire_pathname = NULL;
    }

    return [super free];
}

- setMP3Filename:(const char *)name_
{
    assert(name_);
    assert(not entire_pathname);
    entire_pathname = strdup(name_);
    return self;
}

- (const char *)getMP3Filename { return entire_pathname; }

- (ALMP3_MP3 *) loadMP3IntoMemory:(void *)data_location :(long)max_size
{
    PACKFILE *fp;
    long music_size;
    assert(entire_pathname);

    fp = pack_fopen(entire_pathname, F_READ);
    if (not fp) {
	fprintf(stderr, "Warning: %s not found.\n", entire_pathname);
	return NULL;
    }

    music_size = pack_fread(data_location, max_size, fp);
    pack_fclose(fp);
    return almp3_create_mp3(data_location, music_size);
}
@end


static BOOL seborrhea_mp3_load(const char *filename, const char *name_sans_ext, unsigned int index,
			       Sebum<SebContainer> *parent, DirectoryList *dirlist)
{
    SebMP3 *seb;

    (void)index, (void)dirlist;

    /* Don't load just the MP3 just yet.  Just keep a list of
       filenames for now. */
    seb = [[SebMP3 alloc] initWithName:name_sans_ext];
    [seb setMP3Filename:filename];
    [parent addToList:seb];
    return YES;
}
