/* -*- ObjC -*- */
#ifndef _seb_included_seborrhea_font_h
#define _seb_included_seborrhea_font_h

#include "seborrhea.h"

enum TEXT_ALIGNMENT {
    ALIGN_LEFT,
    ALIGN_CENTRE,
    ALIGN_RIGHT
};


enum TEXT_DECORATION {
    DECORATION_NONE			= 0x00,
    DECORATION_HORIZONTAL_OUTLINE	= 0x01,
    DECORATION_VERTICAL_OUTLINE		= 0x02,
    DECORATION_OUTLINE			= (DECORATION_HORIZONTAL_OUTLINE|DECORATION_VERTICAL_OUTLINE)
};


@interface SebFont: Sebum
{
    BOOL allow_resize;
}
- (BOOL) loadFromFile:(const char *)filename;
- (BOOL) loadFromMemory:(void *)buffer :(int)buffer_size;

- (BOOL) setFontSize:(int)size;
- (BOOL) setFontSizeOnceOnly:(int)size;

- (unsigned int) textHeight;
- (unsigned int) textLength:(const char *)str;

- (void) putChar:(unsigned int)ch To:(void *)dest X:(int)x Y:(int)y Colour:(int)r :(int)g :(int)b;
- (void) putChar:(unsigned int)ch To:(void *)dest X:(int)x Y:(int)y Colour:(int)r :(int)g :(int)b Decoration:(enum TEXT_DECORATION)decor;

- (void) putString:(const char *)str To:(void *)dest X:(int)x Y:(int)y Colour:(int)r :(int)g :(int)b;
- (void) putString:(const char *)str To:(void *)dest X:(int)x Y:(int)y Colour:(int)r :(int)g :(int)b Decoration:(enum TEXT_DECORATION)decor;
- (void) putString:(const char *)str To:(void *)dest X:(int)x Y:(int)y Colour:(int)r :(int)g :(int)b Alignment:(enum TEXT_ALIGNMENT)align;
- (void) putString:(const char *)str To:(void *)dest X:(int)x Y:(int)y Colour:(int)r :(int)g :(int)b Alignment:(enum TEXT_ALIGNMENT)align Decoration:(enum TEXT_DECORATION)decor;
- (void) putStringTo:(void *)dest X:(int)x Y:(int)y Colour:(int)r :(int)g :(int)b :(const char *)format,...;
- (void) putStringTo:(void *)dest X:(int)x Y:(int)y Colour:(int)r :(int)g :(int)b Decoration:(enum TEXT_DECORATION)decor :(const char *)format,...;
- (void) putStringTo:(void *)dest X:(int)x Y:(int)y Colour:(int)r :(int)g :(int)b Alignment:(enum TEXT_ALIGNMENT)align :(const char *)format,...;
- (void) putStringTo:(void *)dest X:(int)x Y:(int)y Colour:(int)r :(int)g :(int)b Alignment:(enum TEXT_ALIGNMENT)align Decoration:(enum TEXT_DECORATION)decor :(const char *)format,...;
@end

BOOL seborrhea_font_init(Class default_class);
void seborrhea_font_shutdown(void);

#endif
