/* -*- ObjC -*- */
#ifndef _seb_included_seborrhea_dirlist_h
#define _seb_included_seborrhea_dirlist_h

#include <dirent.h>
#include <objc/Object.h>

#ifdef __MINGW__
# define FILTER_TYPE		void

/* File types for `d_type'.  Stolen from dirent.h. */
enum {
    DT_UNKNOWN = 0,
    DT_FIFO = 1,
    DT_CHR = 2,
    DT_DIR = 4,
    DT_BLK = 6,
    DT_REG = 8,
    DT_LNK = 10,
    DT_SOCK = 12,
    DT_WHT = 14
};
#else  /* Linux */
/* Special hack to make it work better with scandir. */
# define FILTER_TYPE		struct dirent
#endif

typedef struct {
    /* Just like Linux dirents. */
    unsigned char d_type;
    char d_name[256];

    /* Special for metafiles. */    
    BOOL loaded;

    /* Special for ZZip: extracted size. */
    int st_size;
} dirent_t;

/*--------------------------------------------------------------*/

@protocol VirtualDirectoryList
- (void *) openFile:(const char *)filename :(unsigned int)index :(void **)buffer :(unsigned int *)buffer_size;
@end

@interface DirectoryList: Object
{
    char *working_directory;		/* The directory we are in. */
    unsigned int nentries, nentries_allocated;
    dirent_t *entries;

    int (*filter)(const FILTER_TYPE *a);
    int (*sorter)(const void *a, const void *b);
}
- (int) appendEntry:(void *)entry;
- freeEntries;
- (void) sort;
- (BOOL) scanDirectory:(const char *)dirname;

- (BOOL) isFile:(unsigned int)nth;
- (BOOL) isDirectory:(unsigned int)nth;
- (BOOL) isLink:(unsigned int)nth;

+ (BOOL) isReal;
- (void *) openFile:(const char *)filename;
- (void) closeFile:(void *)file;

- (unsigned int) numEntries;
- (dirent_t *) getNthEntry:(unsigned int)nth;
- (BOOL) entryIsLoaded:(unsigned int)nth;
- (void) markEntryLoaded:(unsigned int)nth;
@end

#endif
