/* -*- ObjC -*- */
#ifndef _seb_included_seborrhea_allegro_h
#define _seb_included_seborrhea_allegro_h

#include <allegro.h>
#include "seborrhea.h"

@interface SebImageAllegro: Sebum <SebImage>
{
    BITMAP *bitmap;
    int pivot_x, pivot_y;
}
- (BOOL) grabFromBitmap:(BITMAP *)source WithX:(unsigned int)sx Y:(unsigned int)sy W:(unsigned int)w H:(unsigned int)h;
- (BOOL) setBitmap:(BITMAP *)bmp;
/* - (BOOL) loadFromFile:(const char *)filename; */
/* - (BOOL) loadFromMemory:(const void *)buffer :(int)buffer_size; */
- (BITMAP *) bitmap;		/* XXX */
@end

@interface SebImageAllegroWithAlpha: SebImageAllegro
@end

@interface SebSampleAllegro: Sebum <SebSample>
{
    SAMPLE *sample;
    unsigned int default_volume;
}
- (BOOL) loadFromFile:(const char *)filename;
- (BOOL) loadFromMemory:(const char *)file :(DirectoryList *)dirlist;
- (SAMPLE *) sample;		/* XXX */
@end

BOOL seborrhea_allegro_init(void);
void seborrhea_allegro_shutdown(void);

#endif
