/* font-alfont.m,
 *
 * TTF support using alfont.
 */

#include <assert.h>
#include "font-alfont.h"


@implementation SebFontAlFont
- free
{
    if (font) {
	alfont_destroy_font(font);
	font = NULL;
    }

    return [super free];
}

- (BOOL) loadFromFile:(const char *)file
{
    assert(not font);
    font = alfont_load_font(file);
    return font ? YES : NO;
}

- (BOOL) setFontSize:(int)size
{
    assert(font);

    if (alfont_set_font_size(font, size) == ALFONT_OK)
	return YES;
    else
	return NO;
}

	/* Dimensions. */
- (unsigned int) textHeight
{
    assert(font);
    return alfont_get_font_height(font);
}

- (unsigned int) textLength:(const char *)str
{
    assert(font);
    return alfont_text_length(font, str);
}

	/* Simple output routines. */
- (void) putChar:(unsigned int)ch To:(void *)dest X:(int)x Y:(int)y Colour:(int)r :(int)g :(int)b
{
    BITMAP *bmp = dest;
    char str[2];
    assert(bmp && font);

    str[0] = ch; str[1] = '\0';
    alfont_textout_aa_ex(bmp, font, str, x, y, makecol(r, g, b), -1);
}

- (void) putString:(const char *)str To:(void *)dest X:(int)x Y:(int) y Colour:(int)r :(int)g :(int)b
{
    BITMAP *bmp = dest;
    assert(bmp && font);

    alfont_textout_aa_ex(bmp, font, str, x, y, makecol(r, g, b), -1);
}
@end

/*--------------------------------------------------------------*/

BOOL sebfont_alfont_init(void)
{
    if (alfont_init() != ALFONT_OK)
	return NO;

    return seborrhea_font_init([SebFontAlFont class]);
}

void sebfont_alfont_shutdown(void)
{
    seborrhea_font_shutdown();
    alfont_exit();
}
