/* -*- ObjC -*- */
#ifndef _seb_included_container_animation_h
#define _seb_included_container_animation_h

#include "seborrhea.h"

enum SEB_ANIMATION_LOOP_METHOD {
    LOOP_NONE = 0,
    LOOP_FORWARD,
    LOOP_PING_PONG
};

@interface SebAnimation: AbstractSebContainer <SebImage>
{
    unsigned int w, h;
    unsigned int delay;
    enum SEB_ANIMATION_LOOP_METHOD loop_method;
}
- setFrameDelay:(unsigned int)t LoopMethod:(enum SEB_ANIMATION_LOOP_METHOD)loop_method;
- (unsigned int)frameDelay;
- (enum SEB_ANIMATION_LOOP_METHOD)loopMethod;

- (unsigned int) numFrames;
- (Sebum<SebImage> *) getFrame:(int)nth;
- (unsigned int) nextFrame:(unsigned int)curr;
@end

@interface SebAnimator: Sebum <SebImage, UniqueSebum>
{
    SebAnimation *anim;
    int frame, frame_tics;
    enum SEB_ANIMATION_LOOP_METHOD loop_method;
}
- setAnimation:(SebAnimation *)anime;
- setLoopMethod:(enum SEB_ANIMATION_LOOP_METHOD)method;
- (BOOL) animationEnded;
@end

#endif
