/* vulcan.m,
 *
 * Vulcan projectiles are the standard weapon of the player's ship.
 * The red weapon in all top-down shooters, including this one.
 */

#include <allegro.h>
#include <math.h>
#include "collision.inc"
#include "common.h"
#include "debris/line-spark.h"
#include "projectiles/vulcan.h"
#include "seborrhea/seborrhea.h"
#include "sound.h"


static Sebum<SebSample> *fire_sample;


@implementation Vulcan
+ initialize
{
    fire_sample = (Sebum<SebSample> *)[base_sebum getSebumByName:"weapon/vulcan-snd"];
    return self;
}

- init
{
    [super init];

    health = 2;

    sprite = (Sebum<SebImage> *)[base_sebum getSebumByName:"weapon/vulcan"];
    w = [sprite width];
    h = [sprite height];

    angle = M_PI_2;
    speed = 8.0;

    return self;
}

- (void) die
{
    int i;

    /* Some extra sparks. */
    for (i = 0; i < 2*debri_amount; i++)
	[spawn_debris([LineSpark class], x, y, HIGH_LAYER)
		     setAngle:deg2rad(rnd(-180, 0))];
    [super die];
}

+ (enum DAMAGE_TYPE) damageType { return DAMAGE_TYPE_VULCAN; }
@end

/*------------------------------------------------------------*/

void fireVulcan(double x, double y, int level, int *reload, int pid)
{
#define SPAWN_ALLY_PROJ(class,x,y)		[(AllyProjectile *)spawn_projectile(class,x,y,YES) setParentID:pid]

    Class proj = [Vulcan class];

    /* Level 0: 2 x  2 hp/shot * 50/10 shots/sec = 20.0 hp/sec.
       Level 1: 3 x  2 hp/shot * 50/10 shots/sec = 30.0 hp/sec.
       Level 2: 4 x  2 hp/shot * 50/10 shots/sec = 40.0 hp/sec.
    */

    y -= 10;
    if (level == 0) {
        SPAWN_ALLY_PROJ(proj, x-5, y);
	SPAWN_ALLY_PROJ(proj, x+5, y);
    }
    elif (level == 1) {
	SPAWN_ALLY_PROJ(proj, x, y);
	[SPAWN_ALLY_PROJ(proj, x-10, y) setAngle:deg2rad(95.0)];
	[SPAWN_ALLY_PROJ(proj, x+10, y) setAngle:deg2rad(85.0)];
    }
    else {
	[SPAWN_ALLY_PROJ(proj, x-12, y) setAngle:deg2rad(96.0)];
	[SPAWN_ALLY_PROJ(proj, x- 5, y) setAngle:deg2rad(92.0)];
	[SPAWN_ALLY_PROJ(proj, x+ 5, y) setAngle:deg2rad(88.0)];
	[SPAWN_ALLY_PROJ(proj, x+12, y) setAngle:deg2rad(84.0)];
    }

    *reload = 10;

    play_voice_on_channels(fire_sample, x, 192, PRIMARY_WEAPON_CHANNELS);

#undef SPAWN_ALLY_PROJ
}
