/* rocket.m,
 *
 * Enemy missiles.  Slightly slower than player missiles.
 */

#include "common.h"
#include "debris/smoke.h"
#include "projectiles/rocket.h"
#include "seborrhea/seborrhea.h"


@implementation Rocket
- init
{
    [super init];

    speed = 5.0;

    sprite = (Sebum<SebImage> *)[base_sebum getSebumByName:"weapon/missile"];
    w = [sprite width];
    h = [sprite height];
    rotatable_sprite = YES;

    return self;
}

- (int) update
{
    if (--smoke_tics <= 0) {
	spawn_debris([Smoke class], x, y, MEDIUM_LAYER);
	smoke_tics = 2;
    }
    return [super update];
}
@end
