/* pulse-laser.m,
 *
 * Rotatable enemy lasers.  Small, fast, and green.
 */

#include "common.h"
#include "projectiles/pulse-laser.h"
#include "seborrhea/seborrhea.h"


static SebFile *laser_sebum;


@implementation PulseLaser
+ initialize { REGISTER_PROJECTILE(self); return self; }
+ derive_loadDataProjectile(laser_sebum, "data/proj-pulselaser");
+ derive_shutdownProjectile(laser_sebum);

- init
{
    [super init];

    speed = 10.0;

    sprite = (Sebum<SebImage> *)[laser_sebum getSebumByName:"pulse-laser"];
    w = 15;			/* Slightly smaller */
    h = [sprite height];
    rotatable_sprite = YES;

    return self;
}
@end
