/* plasma.m,
 *
 * Enemy blobs of plasma.  Orange/yellow.
 */

#include "common.h"
#include "projectiles/plasma.h"
#include "seborrhea/container-animation.h"


static SebFile *plasma_sebum;
static SebAnimation *plasma_animation;


@implementation Plasma
+ initialize { REGISTER_PROJECTILE(self); return self; }

+ (BOOL) loadData
{
    plasma_sebum = [SebFile new];
    if (not [plasma_sebum loadSebumDirectory:"data/proj-plasma"])
	return NO;

    plasma_animation = (SebAnimation *)[plasma_sebum getSebumByName:"plasma"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(plasma_sebum);
    plasma_animation = nil;
}

- init
{
    [super init];

    speed = rnd(30, 35) / 10.0;

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)[plasma_sebum getSebumByName:"plasma"]];
    w = [sprite width];
    h = [sprite height];
    rotatable_sprite = NO;

    return self;
}
@end
