/* pink.m,
 *
 * "It's Pink!"
 */

#include <math.h>
#include "common.h"
#include "projectiles/pink.h"
#include "seborrhea/seborrhea.h"
#include "seborrhea/container-animation.h"


static SebAnimation *pink_animation, *left_animation;


@implementation PinkOrangeRed
+ initialize
{
    pink_animation = (SebAnimation *)[base_sebum getSebumByName:"weapon/pink"];
    left_animation = (SebAnimation *)[base_sebum getSebumByName:"weapon/pink-l"];
    return self;
}

- init
{
    [super init];

    health = 3;
    speed = 4.2;

    sprite = [[SebAnimator new] setAnimation:pink_animation];
    w = [sprite width];
    h = [sprite height] + 4;

    return self;
}

- (id) setAngle:(double)theta
{
    if ((theta > M_PI_2) || (theta < -M_PI_2))
	[(SebAnimator *)sprite setAnimation:left_animation];
    else
	[(SebAnimator *)sprite setAnimation:pink_animation];

    return [super setAngle:theta];
}
@end

/*------------------------------------------------------------*/

void firePinkOrangeRed(double x, double y, int level, int *reload, int *barrel, int pid)
{
#define SPAWN_ALLY_PROJ(class,x,y,theta)		[[(AllyProjectile *)spawn_projectile(class,x,y,YES) setAngle:theta] setParentID:pid]

    Class proj = [PinkOrangeRed class];

    /* Level 0: 2 x 3 hp/shot * 50/16 shots/sec = 18.8 hp/sec.
       Level 1: 2 x 3 hp/shot * 50/13 shots/sec = 23.1 hp/sec.
       Level 2: 2 x 3 hp/shot * 50/10 shots/sec = 30.0 hp/sec.
    */

    if (*barrel == 0) {
        SPAWN_ALLY_PROJ(proj, x-13, y+5, deg2rad(170.0));
	SPAWN_ALLY_PROJ(proj, x+13, y+5, deg2rad(10.0));
    }
    elif (*barrel == 2) {
	SPAWN_ALLY_PROJ(proj, x- 9, y+1, deg2rad(140.0));
	SPAWN_ALLY_PROJ(proj, x+ 9, y+1, deg2rad(40.0));
    }
    else {
	SPAWN_ALLY_PROJ(proj, x-11, y+3, deg2rad(155.0));
	SPAWN_ALLY_PROJ(proj, x+11, y+3, deg2rad(25.0));
    }

    (*barrel)++;
    if ((level == 0) ||
	(level == 1 && *barrel > 1) ||
	(level == 2 && *barrel > 3))
	*barrel = 0;

    *reload = 16 - 3*level;

#undef SPAWN_ALLY_PROJ
}
